package com.puty.demo.app;

import android.app.Application;

import androidx.annotation.NonNull;

import com.puty.sdk.PrinterInstance;
import com.puty.sdk.utils.LogUtils;

/**
 * @author yk
 * @date 2025-02-26 17:02
 */
public class PrintApplication extends Application implements Thread.UncaughtExceptionHandler {
    /**
     * 异常捕获Handler
     */
    private Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    @Override
    public void onCreate() {
        super.onCreate();
        //初始化日志工具类 调试模式时开启日志 注意：正式环境请关闭日志记录
        LogUtils.init(this,true);
        //获取异常捕获Handler
        defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        //将当前对象this设置为全局的默认未捕获异常处理器
        Thread.setDefaultUncaughtExceptionHandler(this);

        //初始化打印机
        PrinterInstance.init(this);
    }

    @Override
    public void uncaughtException(@NonNull Thread t, @NonNull Throwable e) {
        //记录异常日志到文件
        LogUtils.e("UncaughtException", e);
        //将异常的处理权交还给系统默认的异常处理逻辑。
        defaultUncaughtExceptionHandler.uncaughtException(t, e);
    }
}
