package com.puty.demo.activity;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.RadioGroup;
import android.widget.Toast;

import androidx.annotation.Nullable;

import com.puty.LabelPrint;
import com.puty.PrintMode;
import com.puty.PrintStatusCallback;
import com.puty.activity.BaseActivity;
import com.puty.activity.PrintPreviewActivity;
import com.puty.constant.PrintDirection;
import com.puty.demo.R;
import com.puty.putymovelibrary.newapp.Barcode1DElement;
import com.puty.putymovelibrary.newapp.Barcode2dElement;
import com.puty.putymovelibrary.newapp.Label;
import com.puty.putymovelibrary.newapp.LineElement;
import com.puty.putymovelibrary.newapp.TextElement;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;


public class MainActivity extends BaseActivity implements View.OnClickListener {
    /**
     * 打印头精度
     */
    private RadioGroup rgDpi;
    /**
     * 单图无预览打印
     */
    private Button btnBitmapPrint;
    /**
     * 单图预览打印
     */
    private Button btnBitmapPreviewPrint;
    /**
     * 图片批量无预览打印
     */
    private Button btnBitmapsPrint;
    /**
     * 图片批量预览打印
     */
    private Button btnBitmapsPreviewPrint;
    /**
     * 标签无预览打印
     */
    private Button btnLabelPrint;
    /**
     * 标签预览打印
     */
    private Button btnLabelPreviewPrint;

    /**
     * 0*90报文无预览打印
     */
    private Button btnXml40_90DataPrint;
    /**
     * 40*90报文预览打印
     */
    private Button btnXml40_90DataPreviewPrint;

    /**
     * 30_45_35报文预览打印
     */
    private Button btnXml30_45_35DataPreviewPrint;

    /**
     * 取消打印
     */
    private Button btnCancelPrint;

    /**
     * 断开连接
     */
    private Button btnDisconnect;

    /**
     * ODF设备/光交箱/光分纤箱/光终端盒标签
     */
    private final String xml_40_90 = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>" +
            "<Data>" +
            "<Print>" +
            "<EntityTypeId>1003</EntityTypeId>" +
            "<Text>机房信息</Text>" +
            "<Text>机房名称:济南四里村4层南传输</Text>" +
            "<Text>是否两核两关:是</Text>" +
            "<Text>机房类型:移网核心机房</Text>" +
            "<Text>机房负责人(空间责任人):王中楹</Text>" +
            "<Text>联系方式:15615311791</Text>" +
            "<Text>动力资源责任人:张兴强</Text>" +
            "<Text>动力资源责任人联系方式:15615319852</Text>" +
            "<Code>123456789</Code>" +
            "</Print>" +
            "</Data>";

    /*private final String xml_40_90 ="<?xml version='1.0' encoding='utf-8' ?>" +
            "<Data>" +
            "<Print>" +
            "<EntityTypeId>1003</EntityTypeId>" +
            "<Text>机房信息</Text><Text>机房类型：电力室</Text>" +
            "<Text>机房负责人（空间责任人）：麻桑杰</Text>" +
            "<Text>机房名称：青海海东平安古驿大道133号发电机房</Text>" +
            "<Text>是否两核两关：是</Text><Text>动力资源责任人联系方式：</Text>" +
            "<Text>联系方式：18609737377</Text><Text>动力资源责任人：</Text>" +
            "<Code>1901020304000003cb000126b08d6e3df00000001B9C65E533546BDB7387ABF00000000000000000000000000000000000000000000000000000000000000000</Code>" +
            "</Print>" +
            "</Data>";*/

    /**
     * QS-02F、QS-08F 光路线标识标签
     */
    private final String xml_30_45_35 = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>" +
            "<Data>" +
            "<Print>" +
            "<EntityTypeId>1007</EntityTypeId>" +
            "<Text>天津市水利局二道闸水文监测点/以太网专线</Text>" +
            "<Text>本端：01-02-M1-5</Text>" +
            "<Text>对端：02-03-01-L1</Text>" +
            "<Code>1901020304000001D70001266676BF33A00001B43AE1FE9B5E70C4051AF</Code>" +
            "</Print>" +
            "</Data>";

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_main);
    }

    @Override
    protected void initView(@Nullable Bundle savedInstanceState) {
        rgDpi = findViewById(R.id.rgDpi);
        btnBitmapPrint = findViewById(R.id.btnBitmapPrint);
        btnBitmapPreviewPrint = findViewById(R.id.btnBitmapPreviewPrint);
        btnBitmapsPrint = findViewById(R.id.btnBitmapsPrint);
        btnBitmapsPreviewPrint = findViewById(R.id.btnBitmapsPreviewPrint);
        btnLabelPrint = findViewById(R.id.btnLabelPrint);
        btnLabelPreviewPrint = findViewById(R.id.btnLabelPreviewPrint);
        btnXml40_90DataPrint = findViewById(R.id.btnXml40_90DataPrint);
        btnXml40_90DataPreviewPrint = findViewById(R.id.btnXml40_90DataPreviewPrint);
        btnXml30_45_35DataPreviewPrint = findViewById(R.id.btnXml30_45_35DataPreviewPrint);
        btnCancelPrint = findViewById(R.id.btnCancelPrint);
        btnDisconnect = findViewById(R.id.btnDisconnect);
    }

    @Override
    protected void initListener() {
        btnBitmapPrint.setOnClickListener(this);
        btnBitmapPreviewPrint.setOnClickListener(this);
        btnBitmapsPrint.setOnClickListener(this);
        btnBitmapsPreviewPrint.setOnClickListener(this);
        btnLabelPrint.setOnClickListener(this);
        btnLabelPreviewPrint.setOnClickListener(this);
        btnXml40_90DataPrint.setOnClickListener(this);
        btnXml40_90DataPreviewPrint.setOnClickListener(this);
        btnXml30_45_35DataPreviewPrint.setOnClickListener(this);
        btnCancelPrint.setOnClickListener(this);
        btnDisconnect.setOnClickListener(this);
    }

    @Override
    protected void initData() {

    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.btnBitmapPrint://单图无预览打印
            {
                //选中打印头精度
                int selectedDpiId = rgDpi.getCheckedRadioButtonId();
                //测试位图
                Bitmap bitmap;
                if (selectedDpiId == R.id.rdb203) {
                    //生成测试位图
                    bitmap = loadBitmapFromAssets(this, "label_40_90.png");
                }else{
                    //生成测试位图
                    bitmap = loadBitmapFromAssets(this, "40_90_300dpi_new.png");
                }
                //计算缩放比例
                //float scale = 90 * 8f / bitmap.getWidth();
                //缩放打印图
                //bitmap = com.puty.sdk.utils.BitmapUtils.scaleBitmap(bitmap, scale);

                //打印位图 density  浓度 1~15 0:浓度跟随机器  pagerType 纸张类型：-1:跟随机器 0:连续纸  1:黑标纸  2:间隙纸 3:定位孔紙 offsetX  水平偏移 offsetY  垂直偏移
                LabelPrint.printBitmap(this, bitmap, PrintDirection.DIRECTION_90, 0, -1, 0, 0, new PrintStatusCallback() {
                    @Override
                    public void onPrintError(String error) {
                        Toast.makeText(MainActivity.this, error, Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void onPrintCompleted() {
                        Toast.makeText(MainActivity.this, "打印完成", Toast.LENGTH_SHORT).show();
                    }
                });
            }
            break;
            case R.id.btnBitmapPreviewPrint://单图预览打印
            {
                //选中打印头精度
                int selectedDpiId = rgDpi.getCheckedRadioButtonId();
                //测试位图
                Bitmap bitmap;
                if (selectedDpiId == R.id.rdb203) {
                    //生成测试位图
                    bitmap = loadBitmapFromAssets(this, "label_40_90.png");
                }else{
                    //生成测试位图
                    bitmap = loadBitmapFromAssets(this, "40_90_300dpi_new.png");
                }

                //float scale = 90 * 8f / bitmap.getWidth();
                //缩放打印图
                //bitmap = com.puty.sdk.utils.BitmapUtils.scaleBitmap(bitmap, scale);

                //设置数据源
                PrintPreviewActivity.setBitmap(bitmap);
                Bundle bundle = new Bundle();
                //设置打印模式
                bundle.putInt(PrintMode.MODE_KEY, PrintMode.BITMAP_PRINT);
                //设置打印方向
                bundle.putInt(PrintDirection.PRINT_DIRECTION_KEY, PrintDirection.DIRECTION_90);
                //设置标签id(用于记录当前id标签设置的偏移值，便于下次打印自动使用上次设置 可选)
                bundle.putInt(LabelPrint.LABEL_ID_KEY, 1);//自定义，不同模板给不同id值即可
                //打开打印预览页面
                startActivity(PrintPreviewActivity.class, bundle);
            }
            break;
            case R.id.btnBitmapsPrint://图片批量无预览打印
            {
                //选中打印头精度
                int selectedDpiId = rgDpi.getCheckedRadioButtonId();

                List<Bitmap> bitmaps = new ArrayList<>();
                for (int i = 0; i < 2; i++) {
                    //测试位图
                    Bitmap bitmap;
                    if (selectedDpiId == R.id.rdb203) {
                        //生成测试位图
                        bitmap = loadBitmapFromAssets(this, "label_40_90.png");
                    }else{
                        //生成测试位图
                        bitmap = loadBitmapFromAssets(this, "40_90_300dpi_new.png");
                    }
                    bitmaps.add(bitmap);
                }
                //打印位图 density  浓度 1~15 0:浓度跟随机器  pagerType 纸张类型：-1:跟随机器 0:连续纸  1:黑标纸  2:间隙纸 3:定位孔紙 offsetX  水平偏移 offsetY  垂直偏移
                LabelPrint.printBitmaps(this, bitmaps, PrintDirection.DIRECTION_90, 0, -1, 0, 0, new PrintStatusCallback() {
                    @Override
                    public void onPrintError(String error) {
                        Toast.makeText(MainActivity.this, error, Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void onPrintProgress(int pageIndex) {
                        if (bitmaps.size() > 1) {
                            Toast.makeText(MainActivity.this, "打印第" + pageIndex + "张", Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onPrintCompleted() {
                        Toast.makeText(MainActivity.this, "打印完成", Toast.LENGTH_SHORT).show();
                    }
                });
            }
                break;
            case R.id.btnBitmapsPreviewPrint://图片批量预览打印
            {
                //选中打印头精度
                int selectedDpiId = rgDpi.getCheckedRadioButtonId();
                List<Bitmap> bitmaps = new ArrayList<>();
                for (int i = 0; i < 2; i++) {
                    //测试位图
                    Bitmap bitmap;
                    if (selectedDpiId == R.id.rdb203) {
                        //生成测试位图
                        bitmap = loadBitmapFromAssets(this, "label_40_90.png");
                    }else{
                        //生成测试位图
                        bitmap = loadBitmapFromAssets(this, "40_90_300dpi_new.png");
                    }
                    bitmaps.add(bitmap);
                }
                //设置数据源
                PrintPreviewActivity.setBitmaps(bitmaps);
                Bundle bundle = new Bundle();
                //设置打印模式
                bundle.putInt(PrintMode.MODE_KEY, PrintMode.BITMAPS_PRINT);
                //设置打印方向
                bundle.putInt(PrintDirection.PRINT_DIRECTION_KEY, PrintDirection.DIRECTION_90);
                //打开打印预览页面
                startActivity(PrintPreviewActivity.class, bundle);
            }
            break;
            case R.id.btnLabelPrint://标签无预览打印
            {
                //选中打印头精度
                int selectedDpiId = rgDpi.getCheckedRadioButtonId();
                //打印精度
                float dpi;
                if (selectedDpiId == R.id.rdb203) {
                    dpi = 8;
                }else{
                    dpi = 11.8f;
                }
                List<Label> labels = label_50_30(dpi);
                //标签打印 density  浓度 1~15 0:浓度跟随机器  pagerType 纸张类型：-1:跟随机器 0:连续纸  1:黑标纸  2:间隙纸 3:定位孔紙 offsetX  水平偏移 offsetY  垂直偏移
                LabelPrint.printLabels(this, labels, 0, -1, 0, 0, new PrintStatusCallback() {
                    @Override
                    public void onPrintError(String error) {
                        Toast.makeText(MainActivity.this, error, Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void onPrintProgress(int pageIndex) {
                        if (labels.size() > 1) {
                            Toast.makeText(MainActivity.this, "打印第" + pageIndex + "张", Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onPrintCompleted() {
                        Toast.makeText(MainActivity.this, "打印完成", Toast.LENGTH_SHORT).show();
                    }
                });
            }
            break;
            case R.id.btnLabelPreviewPrint://标签预览打印
            {
                //选中打印头精度
                int selectedDpiId = rgDpi.getCheckedRadioButtonId();
                //打印精度
                float dpi;
                if (selectedDpiId == R.id.rdb203) {
                    dpi = 8;
                }else{
                    dpi = 11.8f;
                }

                Bundle bundle = new Bundle();
                //设置打印模式
                bundle.putInt(PrintMode.MODE_KEY, PrintMode.LABEL_PRINT);
                //设置数据源
                PrintPreviewActivity.setLabels(label_50_30(dpi));
                //打开打印预览页面
                startActivity(PrintPreviewActivity.class, bundle);
            }
                break;
            case R.id.btnXml40_90DataPrint://40*90报文无预览打印
            {
                //报文打印 density  浓度 1~15 0:浓度跟随机器  pagerType 纸张类型：-1:跟随机器 0:连续纸  1:黑标纸  2:间隙纸 3:定位孔紙 offsetX  水平偏移 offsetY  垂直偏移
                LabelPrint.printLabelsByXmlData(this, xml_40_90, 0, -1, 0, 0, new PrintStatusCallback() {
                    @Override
                    public void onPrintError(String error) {
                        Toast.makeText(MainActivity.this, error, Toast.LENGTH_SHORT).show();
                    }


                    @Override
                    public void onPrintCompleted() {
                        Toast.makeText(MainActivity.this, "打印完成", Toast.LENGTH_SHORT).show();
                    }
                });
            }
                break;
            case R.id.btnXml40_90DataPreviewPrint://40*90报文预览打印
            {
                Bundle bundle = new Bundle();
                //设置打印模式
                bundle.putInt(PrintMode.MODE_KEY, PrintMode.XML_DATA_PRINT);
                //设置数据源
                PrintPreviewActivity.setXmlData(xml_40_90);
                //打开打印预览页面
                startActivity(PrintPreviewActivity.class, bundle);
            }
            break;
            case R.id.btnXml30_45_35DataPreviewPrint://30*45-35报文预览打印
            {
                Bundle bundle = new Bundle();
                //设置打印模式
                bundle.putInt(PrintMode.MODE_KEY, PrintMode.XML_DATA_PRINT);
                //设置数据源
                PrintPreviewActivity.setXmlData(xml_30_45_35);
                //打开打印预览页面
                startActivity(PrintPreviewActivity.class, bundle);
            }
            break;
            case R.id.btnCancelPrint://取消打印
                LabelPrint.cancelPrint();
                break;
            case R.id.btnDisconnect://断开连接
            {
                LabelPrint.closeConnection();
            }
                break;
        }
    }

    /**
     * 创建50x30标签模板
     * @return
     */
    private  List<Label> label_50_30(float dpi) {
        List<Label> labels = new ArrayList<>();
        for (int i = 0; i < 3; i++) {//创建3个标签
            //创建标签  name:标签名 w:标签宽度，  h:标签高度，
            Label label = new Label("50*30", 50 * dpi, 30 * dpi);
            //预览图背景
            //label.backGroundImage = getImageFromAssetsFile(context, "45_100.png");
            //标签打印方向 0：水平打印 1:旋转90打印
            label.printDirect = 0;

            //创建一维码
            Barcode1DElement barCodeEl = new Barcode1DElement(this, "123456789", 2 * dpi, 2 * dpi, 20 * dpi, 10 * dpi);
            //一维码字号
            barCodeEl.fontSize = 3 * dpi;
            //文本加粗
            barCodeEl.fontBlod = 1;
            label.Elements.add(barCodeEl);

            //创建二维码元素 单位：像素 注意：10f * 8中的10表示10毫米
            Barcode2dElement qrCodeEl = new Barcode2dElement(this,"H250331010957", 32f * dpi, 2f * dpi, 12 * dpi, 12 * dpi);
            label.Elements.add(qrCodeEl);

            //创建线条元素
            LineElement lineEl = new LineElement(this, 2 * dpi, 16 * dpi, 46 * dpi, 0.5f * dpi);
            //旋转角度
            lineEl.rate = 0;
            //lineEl.lineHeight = 1 * dpi;
            label.Elements.add(lineEl);

            //创建文本元素 content:文本内容 w:文本宽度 h：文本高度 单位：像素 注意：37*dpi 中的37表示37毫米
            TextElement contentEl = new TextElement(this, "床前明月光；疑是地上霜。\n举头望明月，低头思故乡。", 2f * dpi, 20f * dpi, 46 * dpi, 16 * dpi);
            //对齐方式 0：左对齐 1：居中对齐 2:右对齐 3：分散对齐
            contentEl.textMode = 1;
            //是否加粗 0：不加粗 1：加粗
            contentEl.fontBlod = 0;
            //设置字号 单位像素
            contentEl.fontSize = 3.5f * dpi;
            //添加元素到标签
            label.Elements.add(contentEl);
            //添加标签到标签集合
            labels.add(label);
        }
        return labels;
    }

    /**
     * 加载资源图片
     * @param context
     * @param fileName
     * @return
     */
    public static Bitmap loadBitmapFromAssets(Context context, String fileName) {
        InputStream inputStream = null;
        Bitmap bitmap = null;
        try {
            // 获取 AssetManager
            AssetManager assetManager = context.getAssets();
            // 打开 assets 文件夹中的文件
            inputStream = assetManager.open(fileName);
            // 将 InputStream 转换为 Bitmap
            bitmap = BitmapFactory.decodeStream(inputStream);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            // 关闭 InputStream
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bitmap;
    }

}
